<?php

use App\Enums\GenderType;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('patients', function (Blueprint $table) {
      $table->id();
      $table->foreignId('user_id')->nullable()->constrained('users');
      $table->string("name");
      $table->longText("address")->nullable()->fulltext();
      $table->string("phone", 20);
      $table->date("birth_date")->nullable();
      $table->string("gender")->default(GenderType::Male)->index();
      $table->longText("medical_history")->nullable()->fulltext();
      $table->longText("medication_allergy")->nullable()->fulltext();
      $table->timestamps();
      $table->softDeletes();
    });

  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('patients');
  }
};
