import { Link, usePage } from "@inertiajs/react";

const Footer = () => {
  return (
    <footer className="flex justify-center w-full mt-7 sm:mt-12 bg-gradient-to-r from-[#ae22e9] to-[#2144de] !text-white">
      <div className="flex flex-col px-4 sm:px-[100px] w-full sm:items-center sm:justify-center my-8 sm:my-12 max-w-[1380px]">
        <div className="flex flex-col lg:flex-row w-full lg:items-center">
          <img
            src="/assets/images/tixhub-logo.png"
            alt="tixhub-logo"
            className="w-16 h-16 lg:w-[93px] lg:h-[93px]"
          />
          <FeaturedContent />
        </div>

        <hr className="w-full my-6 lg:my-8 border-t border-white/25" />

        <ul className="flex flex-wrap justify-center w-full text-white text-[8px] sm:text-sm">
          <li className="font-normal pr-2 sm:pr-4">
            <Link href="/app/sewa-zoom">Sewa Zoom</Link>
          </li>
          <li className="font-normal px-2 sm:px-4">
            <Link href="/app/about">Tentang</Link>
          </li>
          <li className="font-normal px-2 sm:px-4">
            <Link href="/app/contact">Kontak</Link>
          </li>
          <li className="font-normal px-2 sm:px-4">
            <Link href="/app/blog">Blog</Link>
          </li>
          <li className="font-normal px-2 sm:px-4">
            <Link href="/app/disclaimer">Disclaimer</Link>
          </li>
          <li className="font-normal pl-2 sm:pl-4">
            <Link href="/app/privacy">Privacy Policy</Link>
          </li>
        </ul>
      </div>
    </footer>
  );
};

const FeaturedContent = () => {
  const { footer } = usePage().props;
  return (
    <div className="flex flex-col sm:flex-row gap-[18px] sm:gap-[64px] w-full sm:justify-end mt-3 sm:mt-0 text-[10px] lg:text-[13px]">
      <div className="flex flex-col sm:basis-64">
        <h3 className="font-semibold whitespace-pre">Acara Pilihan</h3>
        {footer?.events?.length === 0 ? (
          <p>Tidak ada data</p>
        ) : (
          footer.events.map((event, index) => (
            <a key={index} href={`/${event.slug}`} className="whitespace-nowrap overflow-hidden text-ellipsis max-w-[95vw] sm:max-w-[20vw] opacity-90">
              {event.title}
            </a>
          ))
        )}
      </div>

      <div className="flex flex-col sm:basis-64">
        <h3 className="font-semibold whitespace-pre">Kategori Pilihan</h3>
        {footer?.categories?.length === 0 ? (
          <p>Tidak ada data</p>
        ) : (
          footer.categories.map((category, index) => (
            <a key={index} href={`/app/category/${category.slug}`} className="whitespace-nowrap overflow-hidden text-ellipsis max-w-[95vw] sm:max-w-[20vw] opacity-90">
              {category.name}
            </a>
          ))
        )}
      </div>

      <div className="flex flex-col sm:basis-64">
        <h3 className="font-semibold whitespace-pre">TixHub Blog</h3>
        {footer?.blogs?.length === 0 ? (
          <p>Tidak ada data</p>
        ) : (
          footer.blogs.map((blog, index) => (
            <a key={index} href={`/blog/${blog.slug}`} className="whitespace-nowrap overflow-hidden text-ellipsis max-w-[95vw] sm:max-w-[20vw] opacity-90">
              {blog.title}
            </a>
          ))
        )}
      </div>
    </div>
  );
};

export default Footer;
