import Input from './Input'
import Select from './Select'
import Checkbox from './Checkbox'
import TextArea from './TextArea'
import FileUploaderInput from './FileUploaderInput'
import DatePicker from './DatePicker'

const Form = ({ index = null, property, inputProps }) => {
  const formProps = { ...inputProps, ...property.props, }

  const availableComponent = {
    input: Input,
    select: Select,
    checkbox: Checkbox,
    textarea: TextArea,
    FileUploader: FileUploaderInput,
    DatePicker: DatePicker,
  }

  if (formProps?.isReactSelect && !formProps.defaultValue) {
    let selectedIndex = null;
    if (formProps.options?.length > 0) {
      selectedIndex = formProps?.data[formProps.name] ? formProps.options?.findIndex((option) => option.value == formProps?.data[formProps.name]) : null
    }    
    if (selectedIndex >= 0) {
      formProps.defaultValue = formProps.options[selectedIndex]
    }    
  }

  const SelectedComponent = availableComponent[property.form]

  if (SelectedComponent) {
    return <SelectedComponent key={index} index={index} {...formProps} />
  }
}

export default Form