import LogoutModal from '@/Components/LogoutModal'
import { Link, usePage } from '@inertiajs/react'
import { useEffect, useState } from 'react'

function Sidebar(props) {
  const { appName } = usePage().props
  const [isHover, setIsHover] = useState(false)

  const handleHover = (state) => {
    props?.setOpen(state)
    setIsHover(state)
  }

  return (
    <>
      <div onMouseEnter={() => handleHover(true)} onMouseLeave={() => handleHover(false)}
        className={` ${props.open ? 'md:w-72 w-96 block' : 'hidden lg:w-20 lg:flex lg:items-center lg:flex-col'} z-[999] 
        bg-white relative transition-all duration-300 ease-in-out `}
      >
        <div className='sticky top-0 left-0'>
          <div className={`min-h-screen max-h-screen overflow-y-auto overflow-x-hidden scrollbar-thin scrollbar-thumb-gray-300 scrollbar-track-white ${isHover ? '' : 'scrollbar-none'}`}>
          <div className='flex items-center justify-center'>
            <Link href='/' className={`ease-in-out border px-4 py-2 rounded-lg bg-gray-200 text-gray-800 mx-auto ${props.open ? 'mt-4 font-semibold' : 'mt-2 text-2xl font-bold'}`}>
              <span>{props.open ? appName : appName?.toString()?.substring(0, 1)}</span>
            </Link>
          </div>
          <ul className='px-5'>
            {props.menu.map((item, i) => (
              <li key={i} className={`rounded-md w-full ${!props.open && 'tooltip tooltip-right'} `} data-tip={item.title}>
                <SidebarLink item={item} {...props} />
              </li>
            ))}
            <li className={`rounded-md ${!props.open && 'w-11 tooltip tooltip-right'} `} data-tip='Logout'>
              <a href='#logout-confirm'>
                <div className={`grid items-center ${props.open ? 'grid-cols-8' : 'grid-cols-1'} p-2 text-lg text-center text-gray-500 rounded-md cursor-pointer hover:scale-105 hover:text-gray-700 gap-x-8`}>
                  <i className={`fas fa-sign-out-alt ${!props.open && 'w-full text-left'}`}></i>
                  <span className={`${!props.open && 'hidden'} origin-left`}>Logout</span>
                </div>
              </a>
            </li>
          </ul>

          </div>
        </div>
      </div>

      <LogoutModal />
    </>
  )
}

function SidebarLink(props) {
  const { item } = props

  if (!!item.dropdown) return <SidebarDropdown item={item} {...props} />

  return (
    <Link href={item.link}>
      <SidebarMenu item={item} {...props} />
    </Link>
  )
}

function SidebarDropdown(props) {
  const { item } = props
  const [isDropdownShow, setIsDropdownShow] = useState(false)

  useEffect(() => {
    setIsDropdownShow(false)

    return () => { }
  }, [props.open])

  return (
    <div className={`${props.open ? '' : 'dropdown'} grid`}>
      <button onClick={() => setIsDropdownShow((state) => props.open ? !state : true)}>
        <div className="flex justify-between items-center relative">
          <SidebarMenu item={item} {...props} />
          {props.open ? (
            <i className={`absolute right-4 text-gray-500 fas ${isDropdownShow ? 'fa-angle-up' : 'fa-angle-down'}`}></i>
          ) : null}
        </div>
      </button>
      <div className={`${props.open ? `${isDropdownShow ? '' : 'hidden'}` : 'absolute dropdown-content menu bg-base-100 z-[1]'} border-2 left-8 top-4 px-4 sm:px-2 py-2 rounded-lg `}>
        <div className="flex flex-col w-full">
          {item.dropdown.map((subItem, i) => (
            <Link key={i} href={subItem.link}>
              <div className="grid grid-cols-12 w-full gap-4 text-left items-center">
                <i className={`col-span-2 ${subItem?.src ?? 'fas fa-circle scale-75 opacity-75'}`}></i>
                <p className='col-span-8 whitespace-pre hover:underline underline-offset-4'>{subItem.title}</p>
              </div>
            </Link>
          ))}
        </div>
      </div>
    </div>
  )
}

function SidebarMenu(props) {
  const { item } = props

  return (
    <div className={`${props.title === item.title && 'text-gray-900'} grid items-center ${props.open ? 'grid-cols-8' : 'grid-cols-1'} p-2 text-lg text-center text-gray-500 rounded-md cursor-pointer hover:scale-105 hover:text-gray-700 gap-x-8`}>
      <i className={`${item.src}  ${!props.open && 'w-full text-left'}`}></i>
      <span className={`${!props.open && 'hidden'} origin-left whitespace-pre`}>{item.title}</span>
    </div>
  )
}

export default Sidebar
