import { useState } from "react";
import SideNavbar from "@/Components/SideNavbar";
import Sidebar from "@/Components/Sidebar";
import { Head, usePage } from "@inertiajs/react";
import FlashMessage from "@/Components/FlashMessage";

function AuthenticatedLayout({ title, children, auth }) {
  const [open, setOpen] = useState(false);
  const sidebarMenu = useSidebarMenu();

  return (
    <div className="flex">
      <Head title={title} />
      <Sidebar title={title} menu={sidebarMenu} open={open} setOpen={setOpen} />
      <div className={` ${open ? "w-16 sm:block sm:w-full" : "block"} min-h-screen flex-1 bg-white border-l`}>
        <SideNavbar setOpen={setOpen} open={open} title={title} auth={auth} link="/admin/dashboard" />
        <div className={`${open && "hidden md:block"}`}>
          <FlashMessage />
          {children}
        </div>
      </div>
    </div>
  );
}

const useSidebarMenu = () => {
  const { user } = usePage().props.auth;

  let sidebarMenu = [
    {
      title: "Dashboard",
      src: "fas fa-tachometer-alt fa-fw",
      link: "/admin/dashboard"
    },
    {
      title: "Pengguna",
      src: "fas fa-users",
      link: "/admin/users"
    },
    {
      title: "Data Dokter",
      src: "fas fa-stethoscope",
      link: "/admin/doctors"
    },
    {
      title: "Data Pasien",
      src: "fas fa-hospital-user",
      link: "/admin/patients"
    },
    {
      title: "Rekam Medis",
      src: "fas fa-notes-medical",
      link: "/admin/medical_records"
    },
    // {
    //   title: "Konfigurasi",
    //   src: "fas fa-gear",
    //   dropdown: [
    //     {
    //       title: "Pengaturan Umum",
    //       link: "/admin/configuration"
    //     }
    //   ]
    // },
  ];

  let routes = []

  if (["editor"].includes(user?.role)) {
    routes = [
      "/admin/dashboard",
    ];
  }

  if (routes.length > 0) {
    sidebarMenu = sidebarMenu.filter((menu) => {
      if (!menu.link && !!menu.dropdown) {
        menu.dropdown = menu.dropdown.filter((subMenu) => {
          return routes.includes(subMenu.link);
        });

        return menu.dropdown.length > 0;
      }

      return routes.includes(menu.link);
    });
  }


  return sidebarMenu;
};
export default AuthenticatedLayout;
