
export default function Guest({ children }) {
  return (
    <div className="min-h-screen flex flex-col md:flex-row items-center md:items-stretch font-sans w-full h-full">
      <div className="text-white flex flex-col justify-center items-center md:items-end w-full p-10"
        style={{
          backgroundImage: `
          linear-gradient(to bottom right, rgba(10, 23, 78, 0.85), rgba(18, 41, 95, 0.85)),
          url('/image/guest_bg.webp')
        `,
          backgroundSize: 'cover',
          backgroundPosition: 'center',
        }}>
        <div className="flex-1 flex flex-col justify-center ">
          <h1 className="text-4xl font-semibold mb-3">Selamat Datang</h1>
          <p className="text-lg leading-relaxed text-gray-300">
            Sistem Pencatatan Rekam Medis
          </p>
        </div>
      </div>

      <div className="flex items-center justify-center bg-white w-full md:justify-start md:p-10">
        <div className="border w-full max-w-xl p-2">
          {children}
        </div>
      </div>
    </div>
  );
}
