import FlashMessage from '@/Components/FlashMessage'
import Footer from '@/Components/Footer'
import LogoutModal from '@/Components/LogoutModal'
import { Head, Link, usePage } from '@inertiajs/react'
import { useEffect } from 'react'

function HomeLayout({ Breadcrumb = null, footer = true, children }) {
  const { url, props } = usePage()
  const { title, appName } = props

  let appLogo = '/image/logo.png'
  if (appName == 'TixHub') {
    appLogo = '/image/tixhub_logo.jpeg'
  }

  return (
    <>
      <Head title={title} />
      <div className="relative flex flex-col justify-between w-full min-h-screen max-w-[100vw] overflow-hidden">
        <div className="">
          <NavBar />
          <div className="mx-auto pt-[132px] flex flex-col px-[20px] sm:px-[70px] justify-center items-center w-full mt-[24px] sm:mt-[48px]">
            {Breadcrumb ? <Breadcrumb /> : null}
            {children}
          </div>
        </div>
        {footer ? <Footer /> : null}
      </div>
      <FlashMessage />
      <LogoutModal />
    </>
  )
}

const Auth = () => {
  const user = usePage().props.auth.user
  const picture = user?.picture ? user.picture : `/image/user.png`

  const navbarMenu = [
    {
      title: 'Beranda',
      src: 'fas fa-2x fa-home',
      link: '/',
    },
    {
      title: 'Pesanan Saya',
      src: 'fas fa-2x fa-clipboard',
      link: '/app/order',
    },
  ]

  return user?.role == 'user' ? (
    <div className="dropdown dropdown-end">
      <label tabIndex={0} className="btn btn-ghost btn-circle avatar">
        <div className="w-10 normal-case border-2 rounded-full">
          <img src={picture} alt="Account" width={50} />
        </div>
      </label>
      <ul tabIndex={0} className="z-50 p-2 mt-3 bg-white shadow dropdown-content rounded-box w-max">
        <li className="p-4 h-max">
          <div className="flex flex-col items-center justify-center gap-y-6">
            <div className="flex flex-row items-start gap-x-3">
              <div className="avatar">
                <div className="w-10 h-10 border-2 rounded-full">
                  <img src={picture} alt="Account" width={50} />
                </div>
              </div>
              <div className="flex flex-col w-full">
                <div className="font-bold">{user?.name}</div>
                <p className="text-sm">{user?.email}</p>
              </div>
            </div>
            <div className="flex flex-wrap items-center justify-between w-full gap-2">
              {navbarMenu.map((menu, i) => (
                <Link key={i} className="text-gray-700 cursor-pointer hover:text-primary" href={menu.link}>
                  <div className="flex flex-col items-center gap-2">
                    <i className={menu.src}></i>
                    <p className="text-sm">{menu.title}</p>
                  </div>
                </Link>
              ))}
              <a className="text-gray-700 cursor-pointer hover:text-primary" href="#logout-confirm">
                <div className="flex flex-col items-center gap-2">
                  <i className="fas fa-2x fa-sign-out-alt"></i>
                  <p className="text-sm">Logout</p>
                </div>
              </a>
            </div>
          </div>
        </li>
      </ul>
    </div>
  ) : (
    <Link href={'/app/dashboard'} className="whitespace-pre btn-primary btn btn-sm">
      Dashboard
    </Link>
  )
}

const NavBar = () => {
  const { props } = usePage()
  const user = props?.auth?.user

  const handleToggleMenu = () => {
    const mobileMenu = document.getElementById("mobile-menu");

    const isOpen = mobileMenu.classList.contains("h-0");
    if (isOpen) {
      mobileMenu.classList.remove("h-0", "opacity-0");
      mobileMenu.classList.add("h-screen", "opacity-100");
    } else {
      mobileMenu.classList.remove("h-screen", "opacity-100");
      mobileMenu.classList.add("h-0", "opacity-0");
    }
  }

  useEffect(() => {
    const menuBtn = document.getElementById("menu-btn");

    menuBtn.addEventListener("click", handleToggleMenu);

    return () => {
      menuBtn.removeEventListener("click", handleToggleMenu);
    }
  }, [])


  return (
    <nav
      className="fixed top-0 left-0 w-full z-50 flex flex-col"
      style={{
        backgroundImage: 'linear-gradient(90deg, rgba(174, 34, 233, 1), rgba(33, 68, 222, 1))',
        height: 'auto',
      }}
    >

      <div
        className="flex px-[20px] md:px-[70px] justify-between items-center w-full h-[132px]"
      >
        <a href='/'>
          <img
            src="/assets/images/tixhub-logo.png"
            alt="tixhub logo"
            className="logo"
          />
        </a>


        <button id="menu-btn" className="md:hidden text-white focus:outline-none">
          <svg
            className="w-8 h-8"
            fill="none"
            stroke="currentColor"
            strokeWidth="2"
            viewBox="0 0 24 24"
            strokeLinecap="round"
            strokeLinejoin="round"
          >
            <path d="M4 6h16M4 12h16M4 18h16"></path>
          </svg>
        </button>


        <ul className="hidden md:flex text-base text-white">
          <li className="font-bold md:pr-[10px] xl:pr-[40px]">
            <a href="/">Home</a>
          </li>
          <li className="font-normal md:px-[10px] xl:px-[40px]">
            <Link href="/app/sewa-zoom">Sewa Zoom</Link>
          </li>
          <li className="font-normal md:px-[10px] xl:px-[40px]">
            <Link href="/app/about">Tentang</Link>
          </li>
          <li className="font-normal md:px-[10px] xl:px-[40px]">
            <Link href="/app/contact">Kontak</Link>
          </li>
          <li className="font-normal md:pl-[10px] xl:pl-[40px]">
            <Link href="/app/blog">Blog</Link>
          </li>
        </ul>

        {user ? (
          <Auth />
        ) : (
          <Link href='/auth/login' type="button" className="hidden md:flex bg-bg-button text-white px-[32px] py-[14px] rounded-[10px] cursor-pointer">
            <span>Login</span>
            <img
              src="/assets/icons/Logout.svg"
              alt=""
              className="w-[24px] ml-[16px]"
            />
          </Link>
        )}
      </div>


      <div id="mobile-menu" className="transition-max h-0 opacity-0 md:hidden">
        <ul
          className="flex flex-col items-center text-base text-white px-6 py-4 space-y-2"
        >
          <li className="font-bold"><a href="/">Home</a></li>
          <li className="font-normal"><Link href="/app/sewa-zoom">Sewa Zoom</Link></li>
          <li className="font-normal"><Link href="/app/about">Tentang</Link></li>
          <li className="font-normal"><Link href="/app/contact">Kontak</Link></li>
          <li className="font-normal"><Link href="/app/blog">Blog</Link></li>
        </ul>


        {user ? (
          <Auth />
        ) : (
          <Link href='/auth/login' type="button" className="flex bg-bg-button text-white justify-center py-[14px] rounded-[10px] cursor-pointer mx-6 my-4">
            <span>Login</span>
            <img
              src="/assets/icons/Logout.svg"
              alt=""
              className="w-[24px] ml-[16px]"
            />
          </Link>
        )}

      </div>
    </nav>
  )
}

const NavbarMenu = () => {
  const { relationLink } = usePage().props
  return (
    <>
      {relationLink?.map((link, index) => (
        <a key={index} target="_blank" href={link.value} className="btn btn-sm btn-primary btn-outline">
          {link.description}
        </a>
      ))}
    </>
  )
}

export default HomeLayout
