import FlashMessage from "@/Components/FlashMessage";
import HomeLayout from "@/Layouts/HomeLayout";
import {  usePage } from "@inertiajs/react";
import Pagination from "@/Components/Pagination";

function UserLayout(state) {
  const { children, links = null } = state;
  const { auth } = usePage().props;

  return (
    <HomeLayout auth={auth}>
      <div className="w-full max-w-4xl 2xl:max-w-7xl mx-auto px-2 sm:px-0 relative">
        <FlashMessage />
        {children}
      </div>
      {!links ? null : (
        <div className="grid mb-8 place-content-center w-full max-w-4xl 2xl:max-w-7xl mx-auto">
          <Pagination links={links} />
        </div>
      )}
    </HomeLayout>
  );
}
export default UserLayout;
