import useFormBuilder from "@/utlis/useFormBuilder"
import FormBuilder from "@/Components/FormBuilder"
import { handleSelectReload } from "@/utlis/useFormChange"
import { useSearchParams } from "@/utlis/format"

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  return <FormBuilder {...builderProps} />
}

const getProperties = (state) => {
  const { props, setData } = state
  const { params } = useSearchParams(props.location)  

  const properties = [
    [
      {
        form: "input",
        props: {
          name: "name",
          label: "Nama",
        },
      },
      {
        form: 'select',
        props: {
          isReactSelect: true,
          isCreateAble: true,
          name: 'institute',
          label: 'Instansi',
          options: props.institutes,
          handleChange: (e) => handleSelectReload({ e, name: 'institute', setData, params }),
        }
      },
    ],
  ]

  return properties
}

export default MainForm
