import useFormBuilder from "@/utlis/useFormBuilder"
import FormBuilder from "@/Components/FormBuilder"
import { useSearchParams } from "@/utlis/format"
import { handleSelectReload } from "@/utlis/useFormChange"
import DetailModalItem from "@/Components/Default/DetailModalItem"
import { useTableHeader as PatientHeader } from "@/Pages/Admin/Patient/Index"
import { useTableHeader as MedicalRecordHeader } from "@/Pages/Admin/MedicalRecord/Index"
import { Link, usePage } from "@inertiajs/react"
import { AddButton } from "@/Components/Form/BaseForm"
import Table from "@/Components/Table"

function MainForm({ isEdit = false }) {
  const formConfig = { isEdit, getProperties }
  const builderProps = useFormBuilder(formConfig)

  return <FormBuilder {...builderProps} />
}

const getProperties = (state) => {
  const { props, setData } = state
  const { params } = useSearchParams(props.location)

  const properties = [
    [
      {
        form: 'select',
        props: {
          isReactSelect: true,
          name: 'patient_id',
          label: 'Pasien',
          options: props.patients,
          handleChange: (e) => handleSelectReload({ e, name: 'patient_id', setData, params, only: ['selected_patient', 'selected_medical_records'] }),
          alt: <AddButton path={`/admin/patients/create?ref=${props.location}`} />
        }
      },
      {
        form: 'select',
        props: {
          isReactSelect: true,
          name: 'doctor_id',
          label: 'Dokter',
          options: props.doctors,
          handleChange: (e) => handleSelectReload({ e, name: 'doctor_id', setData, params }),
          alt: <AddButton path={`/admin/doctors/create?ref=${props.location}`} />
        }
      },
      {
        form: "input",
        props: {
          type: "date",
          name: "date",
          label: "Tanggal",
        },
      },
    ],
    [
      {
        form: "textarea",
        props: {
          name: "complaint",
          label: "Keluhan",
          bottomLabel: "Tekan Enter untuk menambahkan baris baru"
        },
      },
    ],
    [
      {
        form: "textarea",
        props: {
          name: "note",
          label: "Keterangan",
          heightClassName: "h-44",
          bottomLabel: "Tekan Enter untuk menambahkan baris baru"
        },
      },
      {
        form: "textarea",
        props: {
          name: "treatment",
          label: "Tindakan",
          heightClassName: "h-44",
          bottomLabel: "Tekan Enter untuk menambahkan baris baru"
        },
      },
    ],
    [
      {
        custom: (props) => <PatientInfoCard {...props} />
      },
    ],
  ]

  return properties
}


const PatientInfoCard = () => {
  const { selected_patient, selected_medical_records, location } = usePage().props
  if (!selected_patient) return <></>

  let medicalRecordHeader = MedicalRecordHeader()
  medicalRecordHeader = medicalRecordHeader?.filter((header) => ["id", "date", "complaint", "note", "treatment"].includes(header.value))

  return (
    <div className="w-full flex flex-col md:flex-row gap-2">
      <div className="w-full max-w-lg border p-2">
        <div className="flex flex-wrap justify-between">
          <p className="text-purple-400 font-semibold">Data Pasien</p>
        </div>
        <DetailModalItem data={selected_patient} tableHeader={PatientHeader()} />

        <div className="mt-2 flex justify-end">
          <Link href={`/admin/patients/${selected_patient?.id}/edit?ref=${location}`} className="btn btn-sm btn-outline">
            <i className="fas fa-edit"></i>
            Perbarui Data
          </Link>
        </div>
      </div>

      <div className="flex-1 border p-2 h-full max-h-[25rem] overflow-auto">
        <div className="flex flex-wrap justify-between">
          <p className="text-purple-400 font-semibold">Data Rekam Medis</p>
        </div>
        <Table tableHeader={medicalRecordHeader} tableBody={selected_medical_records ?? []} />
      </div>
    </div>
  )
}

export default MainForm
