import { Link, usePage } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { ModalButton } from "@/Components/WithModal";
import Table from "@/Components/Table";
import DeleteModal from "@/Components/Modal/DeleteModal";
import { useSearchParams } from "@/utlis/format";
import RestoreModal from "@/Components/Modal/RestoreModal";
import { useAtom } from "jotai";
import { showModalAtom } from "@/atoms";
import DetailModal from "@/Components/Modal/DetailModal";
import DetailModalContent from "@/Components/Default/DetailModalContent";

function Index(props) {
  const tableHeader = useTableHeader();
  const filterOptions = useFilterOptions();

  const [show, setShow] = useAtom(showModalAtom)
  const handleShow = (data) => {
    setShow(data)
  }

  return (
    <AuthenticatedLayout title={props?.title}>
      <Table search filter
        filterOptions={filterOptions}
        tableHeader={tableHeader}
        tableBody={props?.[props?.page?.name]?.data ?? []}
        tablePage={props?.[props?.page?.name]?.links}
        headerButton={() => (
          <>
            <Link href={`${props?.page?.url}/create`} className="btn btn-primary w-max btn-sm text-white">
              Tambah {props?.page?.label}
            </Link>
          </>
        )}
        tableAction={(data) => (
          <>
            <li>
              <ModalButton id={`detail_${data?.id}`} onClick={() => handleShow(data)}>
                <span>Lihat Detail</span>
              </ModalButton>
            </li>
            {data.deleted_at ? (
              <li>
                <ModalButton id={`modal_restore_${data?.id}`} onClick={() => handleShow(data)}>
                  Pulihkan Data
                </ModalButton>
              </li>
            ) : (
              <li>
                <Link href={`${props?.page?.url}/${data.id}/edit`} className=''>
                  Edit
                </Link>
              </li>
            )}
            <li>
              <ModalButton id={`modal_delete_${data?.id}`} onClick={() => handleShow(data)}>
                Hapus {data.deleted_at ? 'Permanen' : ''}
              </ModalButton>
            </li>
          </>
        )}
      />

      {show ? (
        <>
          <DeleteModal id={show?.id} label={show.name} isForceDelete={show.deleted_at != null} handleClick={() => handleShow(null)} />
          <RestoreModal id={show?.id} label={show.name} handleClick={() => handleShow(null)} />
          <DetailModal id={show?.id} tableHeader={tableHeader} data={show} handleClick={() => handleShow(null)} content={(data) => DetailModalContent(data, tableHeader)} />
        </>
      ) : null}
    </AuthenticatedLayout>
  );
}

const useTableHeader = () => {
  const { page, location } = usePage().props
  const { params } = useSearchParams(location)

  const header = [
    {
      label: "#",
      value: "id",
      type: "numbering",
    },
    {
      label: `Nama`,
      value: "name",
      isSearchable: true,
      isModalDetail: true,
    },
    {
      label: `Email`,
      value: "email",
      isSearchable: true,
    },
    {
      label: `Role`,
      value: "role",
    },
    {
      label: "Status",
      value: "status",
      type: "status",
      className: 'w-[10%]',
    },
    {
      label: "Dibuat",
      value: "created_at",
      type: "date",
      isSearchable: true,
      className: 'text-[13px] w-[10%] md:w-[100px] !whitespace-pre',
    },
    {
      label: "Dihapus",
      value: "deleted_at",
      type: "date",
      className: 'w-[10%] !whitespace-pre',
      isHidden: params.get('deleted_at') != 'show',
      className: 'text-[13px] w-[10%] md:w-[100px] !whitespace-pre',
    },
    {
      label: "Aksi",
      value: "id",
      type: "action",
      className: 'w-[10%]',
    },
  ];

  return header;
};

const useFilterOptions = () => {
  const { props } = usePage()
  const filterOptions = [
    {
      name: 'role',
      data: props?.role,
      label: 'Pilih Role',
    },
    {
      name: 'status',
      data: props?.status,
      label: 'Filter Status',
    },
    {
      name: 'deleted_at',
      label: 'Filter Data Terhapus',
    },
  ]

  return filterOptions
};

export default Index;
