import { usePage } from "@inertiajs/react"
import { useStatusLabel } from "./useStatus"
import { jsonParse } from "./format"

const configurationLang = {
  "CTA_ACTION": "Jenis CTA",
  "CTA_FORM": "Form CTA",
  "GTM_ID": "ID Google Tag Manager",
  "GOOGLE_VERIFICATION": "Kode Google Search Verification",
  "CS_CHAT": "Chat Customer Service",
}

const langs = {
  ...configurationLang,
  Admin: "Admin",
  show: "Tampilkan",
  hidden: "Sembunyikan",
  "lang.id": "Indonesia",
  "lang.en": "Inggris",

  "category.product": "Produk",
  "category.article": "Artikel",

  "banner.image": "Gambar",
  "banner.video": "Video",

  "profile.companyName": "Nama Aplikasi",
  "profile.about": "Tentang Aplikasi",
  "profile.tagline": "Tagline",
  "profile.email": "Email",
  "profile.phone": "Telepon",
  "profile.whatsapp": "Whatsapp",
  "profile.facebook": "Facebook",
  "profile.instagram": "Instagram",
  "profile.youtube": "Youtube",
  "profile.officeAddress": "Address",
  "profile.addressMap": "Address Map",
  "profile.location": "Lokasi Aplikasi",

  "seo.default": "Default",

  "male": "Pria",
  "female": "Wanita",
  "other": "Lainnya"
}
function useLang(string, pageProps = null) {
  if (!string) return ''

  let translation = getTranslation(pageProps)
  const translations = { ...translation, ...langs }
  return translations[string] ?? useStatusLabel(string) ?? string
}

const getTranslation = (props) => {
  if (!props) {
    props = usePage().props
  }
  const { lang_translation, lang } = props
  let contents = jsonParse(lang_translation?.content)

  if (!contents) {
    contents = {}
  }

  const defaultLang = "id"

  let jsonContent = {}
  const allTranslations = import.meta.glob("@/locales/**/*.json", { eager: true })
  let matchPath = Object.keys(allTranslations).find((path) => path.includes(`/${lang}/`))

  if (!matchPath) {
    matchPath = Object.keys(allTranslations).find((path) => path.includes(`/${defaultLang}/`))
  }

  if (matchPath) {
    jsonContent = allTranslations[matchPath].default
  }

  contents = { ...jsonContent, ...contents }
  return contents
}

export default useLang
