<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\UsersController;
use App\Http\Controllers\Admin\ConfigurationController;

/*
|--------------------------------------------------------------------------
| Backoffice Routes
|--------------------------------------------------------------------------
|
*/

Route::middleware(['auth', 'role:admin'])
  ->prefix('admin')
  ->name('admin.')
  ->group(function () {
    Route::resource('/users', UsersController::class)->only('index', 'create', 'edit', 'store', 'update', 'destroy');
    Route::resource('/configuration', ConfigurationController::class)->only('index', 'store', 'destroy');
    Route::resource('/doctors', \App\Http\Controllers\Admin\DoctorController::class)->only('index', 'create', 'edit', 'store', 'update', 'destroy');
    Route::resource('/medical_records', \App\Http\Controllers\Admin\MedicalRecordController::class)->only('index', 'create', 'edit', 'store', 'update', 'destroy');
    Route::resource('/patients', \App\Http\Controllers\Admin\PatientController::class)->only('index', 'create', 'edit', 'store', 'update', 'destroy');
  });
