import defaultTheme from "tailwindcss/defaultTheme";
import forms from "@tailwindcss/forms";

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        "./vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php",
        "./storage/framework/views/*.php",
        "./resources/views/**/*.blade.php",
        "./resources/views/*.blade.php",
        "./resources/js/**/*.jsx",
        "./resources/js/**/*.js",
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ["Figtree", ...defaultTheme.fontFamily.sans],
            },
        },
    },

    daisyui: {
      themes: [
        {
          light: {
            ...require('daisyui/src/theming/themes')['light'],
            'primary': process.env.VITE_PRIMARY_COLOR ?? "blue",
            'primary-focus': process.env.VITE_PRIMARY_FOCUS_COLOR ?? "mediumblue",
            'primary-content': 'white',
            'success': '#00A96E',
            'success-focus': '#166534',
            'secondary': '#FABC09',
            'secondary-content': 'black',
            'error': '#DC2626',
            'error-content': 'white',
            '--btn-text-case': 'normal'
          }
        }
      ]
    },

    plugins: [forms, require('daisyui'), require('tailwind-scrollbar')]
};
